#!/bin/sh

#DEBUG=echo
SED=/bin/sed
RM=/bin/rm
AWK=/usr/bin/awk
COPY=/bin/cp
SYNC=/bin/sync
OLD_CONF=/mnt/config/.configured
NEW_CONF=/mnt/config/.configured_4.8
CURRENT_CONF_VER=$(cut -f2 -d " " /etc/version | cut -f 1,2 -d . | cut -f1 -d-)
CURRENT_CONF=/mnt/config/.configured_$CURRENT_CONF_VER
TMP_CONF=/tmp/.configured.tmp
AP_DEF_CONF=/etc/json-config/ap.json
STA_DEF_CONF=/etc/json-config/sta.json
SKU_FILE=/proc/sku
MAX_VERSION=255
VERSION="$(cut -f2 -d " " /etc/version | cut -f1 -d-)"
HW_VERSION="-1"
[ -f $SKU_FILE ] && HW_VERSION="$(cat /proc/sku)"
NEEDS_SAVE=

#Calculate in sw version representation: int = 255*(255*x+y)+z
convert() {
        x=${1//[!0-9]/}
        y=${2//[!0-9]/}
        z=${3//[!0-9]/}
        echo $(( (x * MAX_VERSION + y) * MAX_VERSION + z ))
}

#Convert dots to spaces in version string
intver() {
        convert ${1//\./ }
}

if [ "$(intver $VERSION)" -lt "$(intver 3.3.0)" -a $HW_VERSION -ge 100 ]; then
    exit 0
fi

QOS_SECTION_TYPE_PARAMS="type value queue voip dscp cos vlanid ethertype ipv4 mac broadcast multicast"
device_mode="$(json-config get wireless @wifi-iface[0] mode)"
hw_lock_bit="$(iwpriv wifi0 is_ctry_locked | sed 's/.*\://g')"
network_mode="$(json-config get network mode type)"
lan_proto="$(json-config get network lan proto)"
lan_ipaddr="$(json-config get network lan ipaddr)"
lan_netmask="$(json-config get network lan netmask)"
lan_gateway="$(json-config get network lan gateway)"
lan_dns="$(json-config get network lan dns)"

wan_proto="$(json-config get network wan proto)"
wan_ipaddr="$(json-config get network wan ipaddr)"
wan_netmask="$(json-config get network wan netmask)"
wan_gateway="$(json-config get network wan gateway)"
wan_dns="$(json-config get network wan dns)"

bridge_proto="$(json-config get network mode bridge_proto)"
bridge_ipaddr="$(json-config get network mode bridge_ipaddr)"
bridge_netmask="$(json-config get network mode bridge_netmask)"
bridge_gateway="$(json-config get network mode bridge_gateway)"
bridge_dns="$(json-config get network mode bridge_dns)"

nat_lan_proto="$(json-config get network mode lan_proto)"
nat_lan_ipaddr="$(json-config get network mode lan_ipaddr)"
nat_lan_netmask="$(json-config get network mode lan_netmask)"
nat_lan_gateway="$(json-config get network mode lan_gateway)"
nat_lan_dns="$(json-config get network mode lan_dns)"

nat_wan_proto="$(json-config get network mode wan_proto)"
nat_wan_ipaddr="$(json-config get network mode wan_ipaddr)"
nat_wan_netmask="$(json-config get network mode wan_netmask)"
nat_wan_gateway="$(json-config get network mode wan_gateway)"
nat_wan_dns="$(json-config get network mode wan_dns)"

acs_enable="$(json-config get acs @wifi-iface[0] acs_enable)"
case "$hw_lock_bit" in
        0*) [ "$device_mode" == "2" ] && $DEBUG json-config set wireless wifi0 country FA && NEEDS_SAVE=1
        ;;
        1*) $DEBUG json-config set wireless wifi0 country US && NEEDS_SAVE=1
        ;;
esac

# CAMBIUM-SKU   - this is a search keyword - do not remove this
#enable tftp recovery via u-boot for SMPX and SMPX_9342 SKUs
#one-bank boards only(8Mb)
case $HW_VERSION in
	1|2|4|5|6|7|8|9|11|12|13|14|16|18|20|24|25)
		#Check whether u-boot env is not erased (CRC must be OK)
		if ! /usr/sbin/fw_printenv 2>&1 | grep CRC;
		then
			/usr/sbin/fw_setenv tftp_recover 'setenv ipaddr 192.168.1.1; if ping $serverip; then tftp 0x83000000 firmware.bin; bootm 0x83000000; else reset; fi'
			/usr/sbin/fw_setenv bootcmd 'bootm 0x9f0b0000 || run tftp_recover'
		fi
	;;

esac

if [ "$(intver $VERSION)" -lt "$(intver 4.7.0)" ]; then
	local remote_access="$(json-config get snmpd @agent[0] remote_access)"
	if [ -n "$remote_access" ]; then
		# preserve value set by user to stay the same after changing default
		echo '{"snmpd":{"@agent[0]":{"remote_access":"0"}}}' > /etc/json-config/def.d/99-upgrade.json
		json-config set snmpd @agent[0] remote_access $remote_access
		NEEDS_SAVE=1
	else
		# forge new default depending on protocol version and communities set by user
		local def_public_c="$(json-config get snmpd public community)"
		local def_private_c="$(json-config get snmpd private community)"
		local snmpd_proto_c="$(json-config get snmpd @system[0] protocol)"
		[ "$def_public_c" != "public" -o "$def_private_c" != "private" -o "$snmpd_proto_c" = "2" ] && {
			json-config set snmpd @agent[0] remote_access 1
			NEEDS_SAVE=1
		}
	fi
fi

if [ "$(intver $VERSION)" -lt "$(intver 2.6.0)" ]; then
	# Removing CCA from configuration
	$DEBUG json-config delete wireless @wifi-iface[0] cca_enable
	local tdd_ratio="$(json-config get wireless @wifi-iface[0] tdd_ratio)"
	[ "$tdd_ratio" -eq 1 ] && {
		$SED -i 's/tdd_ratio/tdd_ratio_tmp/g' $AP_DEF_CONF
		$DEBUG json-config set wireless @wifi-iface[0] tdd_ratio 1
	}
	NEEDS_SAVE=1
fi

if [ "$(intver $VERSION)" -lt "$(intver 2.4.3)" ]; then
        # Storing acs_enable to diff. config
        [[ -n "$acs_enable" &&  "$acs_enable" -eq 0 ]] && {
                $SED -i 's/acs_enable/acs_enable_tmp/g' $AP_DEF_CONF
                $DEBUG json-config set acs @wifi-iface[0] acs_enable 0
        }
	$DEBUG json-config set devagent main enable 0
	NEEDS_SAVE=1
fi

if [ "$(intver $VERSION)" -lt "$(intver 2.4.0)" -a \
	 "$(intver $VERSION)" -ge "$(intver 2.3.0)" ]; then
	drv_type="$(json-config get wireless wifi0 type)"
	case "$device_mode" in
		1|ap) #
			case "$drv_type" in
				1|tdd) # TDD driver
                    ptp_mode="$(json-config get wireless @wifi-iface[0] ptp_mode)"
                    [ $ptp_mode -eq 1 ] && \
                        $DEBUG json-config set wireless @wifi-iface[0] prot_mode 4 || \
                        $DEBUG json-config set wireless @wifi-iface[0] prot_mode 1
				;;
				2|80211) # (No Standard WiFi in AP mode) Set as TDD driver
					$DEBUG json-config set wireless @wifi-iface[0] prot_mode 1
				;;
			esac
		;;
		2|sta) #
			case "$drv_type" in
				1|tdd) # TDD driver
					$DEBUG json-config set wireless @wifi-iface[0] prot_mode 1
				;;
				2|80211) # SM Wi-Fi mode
					$DEBUG json-config set wireless @wifi-iface[0] prot_mode 2
				;;
			esac
		;;
	esac
	$DEBUG json-config delete wireless wifi0 type
	NEEDS_SAVE=1
fi

if [ "$(intver $VERSION)" -lt "$(intver 1.4.0)" ]; then
	if [ -f $NEW_CONF ]; then
		$DEBUG json-config delete network lan
		$DEBUG json-config delete network wan
	else
		case $network_mode in
			1)
			[ -n "$lan_proto" -a -z $nat_lan_proto ] && {
				nat_lan_proto=$lan_proto
				$DEBUG json-config set network mode lan_proto $lan_proto
			}
			[ -n "$lan_ipaddr" -a -z $nat_lan_ipaddr ] && {
				$DEBUG json-config set network mode lan_ipaddr $lan_ipaddr
			}
			[ -n "$lan_netmask" -a -z $nat_lan_netmask ] && {
				$DEBUG json-config set network mode lan_netmask $lan_netmask
			}
			[ -n "$lan_gateway" -a -z $nat_lan_gateway ] && {
		                $DEBUG json-config set network mode lan_gateway $lan_gateway
		        }
			[ -n "$lan_dns" -a -z $nat_lan_dns ] && {
		                $DEBUG json-config set network mode lan_dns $lan_dns
		        }
			[ -n "$wan_proto" -a -z $nat_wan_proto ] && {
				nat_wan_proto=$wan_proto
				$DEBUG json-config set network mode wan_proto $wan_proto
			}
			[ -n "$wan_ipaddr" -a -z $nat_wan_ipaddr ] && {
				$DEBUG json-config set network mode wan_ipaddr $wan_ipaddr
			}
			[ -n "$wan_netmask" -a -z $nat_wan_netmask ] && {
		                $DEBUG json-config set network mode wan_netmask $wan_netmask
		        }
			[ -n "$wan_gateway" -a -z $nat_wan_gateway ] && {
				$DEBUG json-config set network mode wan_gateway $wan_gateway
			}
			[ -n "$wan_dns" -a -z $nat_wan_dns ] && {
		                $DEBUG json-config set network mode wan_dns $wan_dns
		        }
			;;

			2)
			[ -n "$lan_proto" -a -z "$bridge_proto" ] && {
				bridge_proto=$lan_proto
				$DEBUG json-config set network mode bridge_proto $lan_proto
			}
			[ -n "$lan_ipaddr" -a -z "$bridge_ipaddr" ] && {
				$DEBUG json-config set network mode bridge_ipaddr $lan_ipaddr
			}
			[ -n "$lan_netmask" -a -z "$bridge_netmask" ] && {
				$DEBUG json-config set network mode bridge_netmask $lan_netmask
			}
			[ -n "$lan_gateway" -a -z "$bridge_gateway" ] && {
		                $DEBUG json-config set network mode bridge_gateway $lan_gateway
		        }
			[ -n "$lan_dns" -a -z "$bridge_dns" ] && {
		                $DEBUG json-config set network mode bridge_dns $lan_dns
		        }
			;;
		esac
	fi
	# Migrating QoS
	qos_voip_enable="$(json-config get tddqos main voip_enable)"
	[ -n "$qos_voip_enable" -a "$qos_voip_enable" == 1 ] && {
		for i in $(seq 1 1 14)
		do
			qos_rule="$(json-config get tddqos rule$i queue)"
			[ -z "$qos_rule" ] && {
        			break
			}
		done
		i=$((i-1))
		if [ $i -le 0 ]
		then
			$DEBUG json-config set tddqos rule1 queue 3
			$DEBUG json-config set tddqos rule1 type 3
			$DEBUG json-config set tddqos rule1 value 5
			$DEBUG json-config set tddqos rule2 queue 3
			$DEBUG json-config set tddqos rule2 type 2
			$DEBUG json-config set tddqos rule2 value 46
		else
			#Shifting existing rules by 2
			for n in $(seq $i -1 1)
			do
				for rule_opt in $QOS_SECTION_TYPE_PARAMS
				do
					qos_rule_value=$(json-config get tddqos rule$n $rule_opt)
					[ -n "$qos_rule_value" ] && $DEBUG json-config set tddqos rule$((n+2)) $rule_opt $qos_rule_value
				done
			done	
			# Initialyzing VoIP default rules	
			$DEBUG json-config set tddqos rule1 queue 3
			$DEBUG json-config set tddqos rule1 type 3
			$DEBUG json-config set tddqos rule1 value 5
			$DEBUG json-config set tddqos rule2 queue 3
			$DEBUG json-config set tddqos rule2 type 2
			$DEBUG json-config set tddqos rule2 value 46
		fi
	}

	# Converting Radius Certificates
	radius_user1_cert="$(json-config get wireless radius_certificate_2)"
	radius_user2_cert="$(json-config get wireless radius_certificate_3)"
	$DEBUG json-config delete wireless radius_certificate_2
	$DEBUG json-config delete wireless radius_certificate_3
	[ -n "$radius_user1_cert" ] && $DEBUG json-config set wireless radius radius_user1_cert "$radius_user1_cert"
	[ -n "$radius_user2_cert" ] && $DEBUG json-config set wireless radius radius_user1_cert "$radius_user2_cert"
	
	# Filling-in default auth_port info
        radius2="$(grep radius_server_2 $OLD_CONF)"
        radius3="$(grep radius_server_3 $OLD_CONF)"
	auth_port1="$(json-config get wireless radius_server_1 auth_port)"
	auth_port2="$(json-config get wireless radius_server_2 auth_port)"
	auth_port3="$(json-config get wireless radius_server_3 auth_port)"
	auth_secret1="$(json-config get wireless radius_server_1 auth_secret)"
	auth_server1="$(json-config get wireless radius_server_1 auth_server)"
	$SED -i 's/1812\|\("\)Cambium\("\)\|192\.168\.0\.99/\1\2/g' $AP_DEF_CONF
	[ -n "$auth_server1" ] && $DEBUG json-config set wireless radius_server_1 auth_server $auth_server1
	[ -n "$auth_port1" ] && $DEBUG json-config set wireless radius_server_1 auth_port $auth_port1
	[ -n "$auth_secret1" ] && $DEBUG json-config set wireless radius_server_1 auth_secret $auth_secret1
	[ -n "$radius2" ] && $DEBUG json-config set wireless radius_server_2 auth_port $auth_port2
	[ -n "$radius3" ] && $DEBUG json-config set wireless radius_server_3 auth_port $auth_port3

	# Converting protocols to numeric
	echo > /etc/json-config/value.json
	[ -n "$bridge_proto" ] && {
		$DEBUG json-config set network mode bridge_proto "$bridge_proto"
	}
	[ -n "$nat_lan_proto" ] && {
		$DEBUG json-config set network mode lan_proto "$nat_lan_proto"
	}
	[ -n "$nat_wan_proto" ] && {
		$DEBUG json-config set network mode wan_proto "$nat_wan_proto"
	}
	$DEBUG json-config save

	# Migrating .configured from an OLD BE to New BE
	# Updating parameter names
	$SED 's/\(pref_ap\|host\|rule\|radius_server\|mir_ap_profile\|trapserver\|cambrule\)_\?\([0-9]\+\)/\@\1\[\n\2\n\]/g' $OLD_CONF |
	$SED 's/"10\+\([0-9]\+\)"\:/"\@ebtrule\[\n\1\n\]"/g' |
	$AWK '{ if (/^[0-9]/) { print $0-1} else { print $0 } }' |
	$SED ':begin;$!N;s/\([0-9]\|\[\)\n/\1/;tbegin;P;D' > $NEW_CONF
else
	if [ "$(intver $VERSION)" -lt "$(intver 2.0.0)" ]; then
		# Storing default_security_mode to diff. config
		[ "$(json-config get wireless @wifi-iface[0] default_security_mode)" -eq 0 ] && {
			$SED -i 's/default_security_mode/default_security_mode_tmp/g' $STA_DEF_CONF
			$DEBUG json-config set wireless @wifi-iface[0] default_security_mode 0
			$DEBUG json-config save
		}
	fi
	
	[ "$CURRENT_CONF" != "$NEW_CONF" ] && cp $CURRENT_CONF $NEW_CONF
fi

# After reboot "json-config xgrade" will be provided directly before "json-config active" call
# This is temporary file, will be removed after "json-config xgrade" call
echo $CURRENT_CONF_VER > /mnt/config/xgrade

# Fix calibration mark on some boards
case $HW_VERSION in
13|14|16|17|18)
	dd if=/dev/mtd5 of=/tmp/art.bin 2>/dev/null
	byteval=$(hexdump -e '/1 "%02X"' -n1 -s20480 /tmp/art.bin)
	if [ "$byteval" = "02" ]; then
		cp /tmp/art.bin /tmp/art1.bin
		echo -ne "\x04" | dd of=/tmp/art.bin bs=1 seek=20480 count=1 2>/dev/null
		dd if=/tmp/art1.bin of=/tmp/art.bin bs=1 seek=20481 skip=20481 2>/dev/null
		mtd write /tmp/art.bin /dev/mtd5
	fi
	;;
esac

# Drop Flexible Licensing config which is obsolete
if [ "$(json-config show licensed)" ]; then
	$DEBUG json-config delete licensed
	NEEDS_SAVE=1
fi

[ "$NEEDS_SAVE" ] && $DEBUG json-config save

# Syncing filesystem cache
$SYNC

